;-------------------------------------------------------------------------------
; ZX X-MAS '19 - STARTUP EFFECTS
;
;       (/&&&/\&\  /%/  \&\  /%/   /%)(#)(&\ /%###&\ /###)  ()/%|  /&&&\
;         /%/  \&\/%/    \&\/%/,--,|#||#||#| |#| |#| |&&\     |#| (&___&)
;        /%/   /%/\&\    /%/\&\'--'|#||#||#| |###|#|  \&&|    |#|    (&&)
;       /&&&/)/%/  \&\  /%/  \&\   |#||#||#| |#| |#| (###/    |#| (&&&&/
;
; Copyright AbaddoN (C)2018-2019
; Code and gfx by: G.o.D. / AbaddoN
; Mzx by: ern0 / AbaddoN
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
; Startup IM2 routine

IM2_STARTUP:
	push	af
	push	bc
	push	de
	push	hl
	push	ix
	push	iy
	ex	af,af'
	push	af

	ld	hl,STARTUP_CALL_TABLE
IM2S_CallTableLoop:
STARTUP_PHASE:
	ld	de,0

	ld	c,(hl)
	inc	hl
	ld	b,(hl)				; BC=lower frame bound of effect
	inc	hl
	ld	a,b
	and	c
	inc	a
	jr	z,IM2S_EndOfCallTable
	ex	de,hl				; HL=frame counter / DE=call table pointer
	and	a
	sbc	hl,bc
	jr	c,IM2S_CallTableNextAdd4	; skip if frame counter<lower frame bound
	add	hl,bc
	ex	de,hl				; HL=call table pointer

	ld	c,(hl)
	inc	hl
	ld	b,(hl)				; BC=higher frame bound of effect
	inc	hl
	ex	de,hl				; HL=frame counter / DE=call table pointer
	and	a
	sbc	hl,bc
	jr	nc,IM2S_CallTableNextAdd2 ; skip if frame counter>=higher frame bound
	add	hl,bc
	ex	de,hl				; HL=call table pointer

	ld	c,(hl)
	inc	hl
	ld	b,(hl)				; BC=call pointer
	inc	hl
	push	hl
	ld	(IM2S_EffectCall+1),bc
IM2S_EffectCall:
	call	$1313				; DE=frame counter
	pop	hl
	jr	IM2S_CallTableLoop

IM2S_CallTableNextAdd4:
	inc	de
	inc	de
IM2S_CallTableNextAdd2:
	inc	de
	inc	de
	ex	de,hl
	jr	IM2S_CallTableLoop

IM2S_EndOfCallTable:
	ex	de,hl				; HL=frame counter
	inc	hl
	ld	a,h
	and	l
	inc	a
	jr	z,IM2S_EndOfStartup
	ld	(STARTUP_PHASE+1),hl
IM2S_EndOfStartup:
	pop	af
	ex	af,af'
	pop	iy
	pop	ix
	pop	hl
	pop	de
	pop	bc
	pop	af
	ei
	reti

; Effect call table of startup process.
; Record's 1st word: lower frame bound
;  (fx is called when frame counter >= lower bound)
; Record's 2nd word: higher frame bound
;  (fx is called when frame counter < lower bound)
; Record's 3rd word: fx call address
STARTUP_CALL_TABLE:
	; vaporize out loading screen's title and ribbon (12600T-18700T)
	defw	$0000, $00A0, DO_VAPORIZE_OUT
	; reset paper color at the first part of vaporizing (18076T)
	defw	$0018, $0031, SET_PAPER_TO_BACKGROUND
	; move out loading Xmas tree (4300T - 29000T)
	defw	$0000, $007F, MOVE_OUT_TREE
	; move in background Xmas tree (4800T - 31800T)
	defw	$0080, $00F1, MOVE_IN_TREE
	; put background right attributes (~13600T)
	defw	$00BC, $00BD, PUT_BKG_ATTR
	; vaporize in background right - socks and bells (28200T-33100T)
	defw	$00BC, $160, DO_VAPORIZE_IN
	; scroll in AbaddoN, code,gfx,mzx by and abaddon.hu (12000T-18000T)
	defw	$0160, $0170, SCROLL_IN_TEXTS ;8D-59
	; open curtain effect ($118-$1A5:10600T-25500T / $1A6-1FF:13700T-31400T)
	; vaporize in must be ended before $1A5, the horizontal opening
	; ends at $1FF but continues until the precalcs: COPY_MLTCOL_ATTR and
	; GEN_MLTCOL_CODE finishes. Max. length $FF frames.
	defw	$0124, $020C, OPEN_CURTAIN
	; copy multicolor attributes to destination memory in 2 parts (24100T)
	; must be after DO_VAPORIZE_IN
	defw	$0170, $0172, COPY_MLTCOL_ATTR
	; copy multicolor attributes to destination memory in 2 parts (24100T)
	; must be after DO_VAPORIZE_IN
	defw	$0172, $0178, GEN_MLTCOL_CODE
	; play music in every step (4600T-8145T)
	defw	$0000, $FFFF, MZX_PLAY_PROC
	; must be after every effect - finishes startup effects
	defw	$020C, $020D, STARTUP_END
	; end of table
	defw	$FFFF

; Set end of startup process. Mzx will continue.
STARTUP_END:
	ld	hl,$FFFE
	ld	(STARTUP_PHASE+1),hl

	call	STARTUP_MLTCOL_HEIGHT	; set multicolor height

	ld	de,IM2_PROC			; set IM 2 main routine
	jp	IM2_SET_ROUTINE


;-------------------------------------------------------------------------------
; VAPORIZE MASKS

	defb	$FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF	; mask  0
VAPORIZE_MASK:
	defb	$FF, $FF, $FD, $FF, $FF, $BF, $7F, $FF	; mask  1
	defb	$FF, $FB, $FD, $FB, $FD, $BF, $7F, $FF	; mask  2
	defb	$FF, $FB, $FD, $FB, $F9, $BF, $7D, $FD	; mask  3
	defb	$FF, $FB, $FD, $DB, $C9, $BF, $7D, $FD	; mask  4
	defb	$FF, $BB, $FD, $C9, $C9, $BF, $7D, $FD	; mask  5
	defb	$FF, $BB, $FD, $C9, $C9, $AF, $79, $F5	; mask  6
	defb	$FF, $BB, $7D, $89, $C9, $A7, $79, $F5	; mask  7
	defb	$FF, $BB, $6C, $89, $89, $A7, $79, $F5	; mask  8
	defb	$F3, $BB, $6C, $89, $89, $A7, $39, $F5	; mask  9
	defb	$F3, $BB, $6C, $89, $89, $A7, $19, $C5	; mask 10
	defb	$F3, $AB, $6C, $89, $09, $A7, $18, $C5	; mask 11
	defb	$F2, $AB, $6C, $09, $09, $A7, $18, $C1	; mask 12
	defb	$72, $8B, $6C, $09, $08, $A7, $18, $C1	; mask 13
	defb	$62, $8B, $6C, $08, $08, $A7, $08, $C1	; mask 14
	defb	$62, $8B, $6C, $08, $08, $A1, $08, $41	; mask 15
	defb	$22, $83, $6C, $08, $08, $A1, $08, $01	; mask 16
	defb	$22, $81, $2C, $08, $00, $A1, $08, $00	; mask 17
	defb	$02, $81, $24, $00, $00, $81, $08, $00	; mask 18
	defb	$00, $81, $00, $00, $00, $81, $00, $00	; mask 19
	defb	$00, $00, $00, $00, $00, $00, $00, $00	; mask 20

;-------------------------------------------------------------------------------
; Vaporize in socks and bells
; in:  DE: startup phase
; out: -
; mod: AF,BC,DE,HL,IX
; Areas: $0D10-$0412 / $1158-$0703 / $1340-$080D / $1380-$080D
DO_VAPORIZE_IN:
	; correct attributes what tree move in erases
	ld	hl,$5800+(18*$20)+13	; ribbon left
	ld	bc,$20-2
VAP_IN_RIBBON_ATTR_1:
	ld	(hl),$FA				; #selfmod: attribute
	inc	l
VAP_IN_RIBBON_ATTR_2:
	ld	(hl),$F9				; #selfmod: attribute
	inc	l
VAP_IN_RIBBON_ATTR_3:
	ld	(hl),$F1				; #selfmod: attribute
	add	hl,bc
VAP_IN_RIBBON_ATTR_4:
	ld	(hl),$FA				; #selfmod: attribute
	inc	l
VAP_IN_RIBBON_ATTR_5:
	ld	(hl),$F9				; #selfmod: attribute
	inc	l
VAP_IN_RIBBON_ATTR_6:
	ld	(hl),$F1				; #selfmod: attribute
	ld	hl,$5800+(10*$20)+14	; under the left socks
VAP_IN_RIBBON_SOCKS:
	ld	(hl),$C7				; #selfmod: attribute
	ld	hl,$5800+(23*$20)+14	; start of www.abaddon.hu
VAP_IN_RIBBON_SINCLAIR:
	ld	(hl),$C6				; #selfmod: attribute
	; bells .3 / ~29200T
	push	de
	ld	hl,$0D90				; H:X (chr) / L:Y (px) top left
	ld	bc,$0202				; B: height (chr) / c: width (chr)
	ld	ix,BKG_BELLS_IMAGE_4
	call	VAPORIZE_IN_AREA
	pop	de

	ld	a,e
	and	$07
	jr	nz,DVI_P1
	; bells .4 / ~29800T
	ld	hl,$10A0				; H:X (chr) / L:Y (px) top left
	ld	bc,$030C				; B: height (chr) / c: width (chr)
	ld	ix,BKG_BELLS_IMAGE_5
	jp	VAPORIZE_IN_AREA
DVI_P1:
	dec	a
	jr	nz,DVI_P2
	; bells .3 / ~29200T
	ld	hl,$0F90				; H:X (chr) / L:Y (px) top left
	ld	bc,$0211				; B: height (chr) / c: width (chr)
	ld	ix,BKG_BELLS_IMAGE_3
	jp	VAPORIZE_IN_AREA
	ret
DVI_P2:
	dec	a
	jr	nz,DVI_P3
	; socks .1 / ~18800T
	ld	hl,$0A00				; H:X (chr) / L:Y (px) top left
	ld	bc,$0116				; B: height (chr) / c: width (chr)
	ld	ix,BKG_SOCKS_IMAGE_1
	call	VAPORIZE_IN_AREA
	; socks .6 / ~7700T
	ld	hl,$0F40				; H:X (chr) / L:Y (px) top left
	ld	bc,$0109				; B: height (chr) / c: width (chr)
	ld	ix,BKG_SOCKS_IMAGE_3
	call	VAPORIZE_IN_AREA
	; bells .1 / ~2700T
	ld	hl,$1680				; H:X (chr) / L:Y (px) top left
	ld	bc,$0103				; B: height (chr) / c: width (chr)
	ld	ix,BKG_BELLS_IMAGE_1
	jp	VAPORIZE_IN_AREA
DVI_P3:
	dec	a
	jr	nz,DVI_P4
	; bells .2 / ~8600T
	ld	hl,$1188				; H:X (chr) / L:Y (px) top left
	ld	bc,$010A				; B: height (chr) / c: width (chr)
	ld	ix,BKG_BELLS_IMAGE_2
	call	VAPORIZE_IN_AREA
	; bells .5 / ~2700T
	ld	hl,$15B8				; H:X (chr) / L:Y (px) top left
	ld	bc,$0103				; B: height (chr) / c: width (chr)
	ld	ix,BKG_BELLS_IMAGE_6
	jp	VAPORIZE_IN_AREA
DVI_P4:
	dec	a
	jr	nz,DVI_P5
	; socks .2 / ~30300T
	ld	hl,$0A08				; H:X (chr) / L:Y (px) top left
	ld	bc,$0214				; B: height (chr) / c: width (chr)
	ld	ix,BKG_SOCKS_IMAGE_2
	jp	VAPORIZE_IN_AREA
DVI_P5:
	dec	a
	jr	nz,DVI_P6
	; socks .3 / ~30300T
	ld	hl,$0A18				; H:X (chr) / L:Y (px) top left
	ld	bc,$0214				; B: height (chr) / c: width (chr)
	ld	ix,BKG_SOCKS_IMAGE_2+(2*20*8)
	jp	VAPORIZE_IN_AREA
DVI_P6:
	dec	a
	jr	nz,DVI_P7
	; socks .4 / ~30300T
	ld	hl,$0A28				; H:X (chr) / L:Y (px) top left
	ld	bc,$0214				; B: height (chr) / c: width (chr)
	ld	ix,BKG_SOCKS_IMAGE_2+(4*20*8)
	jp	VAPORIZE_IN_AREA

DVI_P7:
	; socks .4 / ~15400T
	ld	hl,$0A38				; H:X (chr) / L:Y (px) top left
	ld	bc,$0114				; B: height (chr) / c: width (chr)
	ld	ix,BKG_SOCKS_IMAGE_2+(6*20*8)
	call	VAPORIZE_IN_AREA

	ld	hl,(VAPORIZE_IN_CURR_MASK+1) ; next vaporize phase
	ld	de,-8
	add	hl,de
	ld	(VAPORIZE_IN_CURR_MASK+1),hl
	ret

;-------------------------------------------------------------------------------
; Vaporize screen area
; in:  L: top left Y pos px / H: top left X pos chr - L must be divided by 8
;      C: width chr / B: height chr
; out: -
; mod: AF,B,DE,HL

VAPORIZE_IN_AREA:
	ld	a,h
	ld	h,SCRLINE_LOOKUP>>8
	ld	e,(hl)
	inc	h
	ld	h,(hl)
	add	a,e
	ld	l,a					; HL=area screen addr.

VIA_VertLoop:
	push	bc
	push	hl
VIA_HorzLoop:
VAPORIZE_IN_CURR_MASK:
	ld	de,VAPORIZE_MASK+(19*8)
	ld	b,8
VIA_CharLoop:
	ld	a,(de)
	inc	de
	and	(ix+0)
	inc	ix
	ld	(hl),a
	inc	h
	djnz	VIA_CharLoop

	ld	a,h
	sub	8
	ld	h,a
	inc	l
	dec	c
	jr	nz,VIA_HorzLoop

	pop	hl
	pop	bc
	
	ld	a,$20
	add	a,l
	ld	l,a
	
	djnz	VIA_VertLoop
	ret

;-------------------------------------------------------------------------------
; Fine scroll in AbaddoN, code,gfx,mzx by and abaddon.hu
; in:  -
; out: -
; mod: AF,BC,DE,HL

ABD_TEXT_WIDTH			EQU	2	; width of AbaddoN text in chars
ABD_TEXT_HEIGHT		EQU	9	; height of AbaddoN text in chars
ABD_TEXT_Y_POS			EQU	8	; Y position of AbaddoN on background in px
ABD_TEXT_X_POS			EQU	30	; X position of AbaddoN on background in char
SINCLAIR_TEXT_WIDTH		EQU	7	; width of abaddon.hu text in chars
SINCLAIR_TEXT_HEIGHT	EQU	8	; height of abaddon.hu text in px
SINCLAIR_TEXT_Y_POS		EQU	184	; Y position of abaddon.hu on background in px
SINCLAIR_TEXT_X_POS		EQU	14	; X position of abaddon.hu on background in char
SCENERZ_TEXT_WIDTH		EQU	7	; width of scenerz text in chars
SCENERZ_TEXT_HEIGHT		EQU	16	; height of scenerz text in px
SCENERZ_TEXT_Y_POS		EQU	176	; Y position of scenerz text on background in char
SCENERZ_TEXT_X_POS		EQU	25	; X position of scenerz text on background in char

SCROLL_IN_TEXTS:

SIT_Phase:
	ld	a,$11
	dec	a
	ret	z
	ld	(SIT_Phase+1),a

	; scroll up "www.abaddon.hu"
	ld	a,e
	rra
	jr	nc,SIT_AbaddoN
SIT_SinclairHu_YPos:
	ld	l,SINCLAIR_TEXT_Y_POS+SINCLAIR_TEXT_HEIGHT
	dec	l
	ld	a,l
	ld	(SIT_SinclairHu_YPos+1),a
	ld	a,192
	sub	l
	ld	b,a
	ld	h,SCRLINE_LOOKUP>>8
	ld	a,(hl)
	inc	h
	ld	h,(hl)
	add	a,SINCLAIR_TEXT_X_POS
	ld	l,a
	ex	de,hl
	ld	hl,SCROLL_SINCLAIR_IMAGE
SIT_SinclairHu_Scroll:
	ld	c,$FF
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	inc	d
	ld	a,e
	sub	SINCLAIR_TEXT_WIDTH
	ld	e,a
	djnz	SIT_SinclairHu_Scroll

	; scroll left "An AbaddoN Production"
SIT_AbaddoN:
	ld	de,SCROLL_ABADDON_IMAGE+(ABD_TEXT_WIDTH*ABD_TEXT_HEIGHT*8)-1
	ld	l,ABD_TEXT_Y_POS+(ABD_TEXT_HEIGHT*8)-1
	ld	c,ABD_TEXT_HEIGHT
SIT_Abd_Scroll1:
	ld	b,8
	push	hl
	ld	h,SCRLINE_LOOKUP>>8
	ld	a,(hl)
	inc	h
	ld	h,(hl)
	add	a,ABD_TEXT_X_POS+ABD_TEXT_WIDTH-1
	ld	l,a
SIT_Abd_Scroll2:
	ex	de,hl
	rl	(hl)
	dec	hl
	rl	(hl)
	dec	hl
	ex	de,hl
	rl	(hl)
	dec	l
	rl	(hl)
	inc	l
	dec	h
	djnz	SIT_Abd_Scroll2
	pop	hl
	ld	a,l
	sub	8
	ld	l,a
	dec	c
	jr	nz,SIT_Abd_Scroll1

	; scroll up "Code/Gfx:G.o.D. Mzx:z00m"
SIT_Scenerz_YPos:
	ld	e,SCENERZ_TEXT_Y_POS+SCENERZ_TEXT_HEIGHT
	dec	e
	ld	a,e
	ld	(SIT_Scenerz_YPos+1),a
	ld	hl,SCROLL_SCENERZ_IMAGE
	ld	a,192
	sub	e
	ld	b,a
	ld	a,e
SIT_Scenerz_Scroll:
	ex	de,hl				; B=lines to draw / A=Y pos. / HL=image ptr.
	ld	l,a
	ex	af,af'
	ld	h,SCRLINE_LOOKUP>>8
	ld	a,(hl)
	inc	h
	ld	h,(hl)
	add	a,SCENERZ_TEXT_X_POS
	ld	l,a
	ex	af,af'
	ex	de,hl
	ld	c,$FF
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	ldi
	inc	a
	djnz	SIT_Scenerz_Scroll

	ret

;-------------------------------------------------------------------------------
OPCRT_MID_SCRADDR		EQU	$4B95	; middle 2*2 point's screen addr. 99-171
OPCRT_MID_ATTRADDR		EQU	$5800+(12*$20)+21	; middle 2*2 point's attr addr
KKU_MID_X				EQU	171		; middle X position of KKU text
KKU_MID_Y				EQU	99		; middle Y position of KKU text
OPCRT_POINT_BITMAP		EQU	$18		; one line's bitmap of 2*2 point

OPEN_CURTAIN:
OC_Phase:
	ld	a,0					; self modified code - open curtain phase cnt
	inc	a
	ld	(OC_Phase+1),a
	cp	6
	jr	nc,OC_PreCalc
	; fade in middle point
	ld	hl,OPCRT_MID_SCRADDR
	ld	(hl),OPCRT_POINT_BITMAP
	inc	h
	ld	(hl),OPCRT_POINT_BITMAP
	ld	e,a
	ld	d,0
OPEN_CURTAIN_FADEIN:
	ld	hl,$1313
	add	hl,de
	ld	a,(hl)
	ld	(OPCRT_MID_ATTRADDR),a
	ret
	; open line vertically
OC_PreCalc:
	cp	83
	jr	nc,OC_VertOpen
	jp	PRECALC_KKU_TEXT
OC_VertOpen:
	cp	146
	jr	nc,OC_HorzOpen
	and	3
	jp	nz,PRECALC_KKU_TEXT
OC_VertPhase:
	ld	a,0
	inc	a
	ld	(OC_VertPhase+1),a
	ld	b,a
	ld	a,KKU_MID_Y+1
	sub	b
	ld	c,a
	sla	b
OC_VertLoop:
	ld	l,c
	ld	h,SCRLINE_LOOKUP>>8
	ld	a,(hl)
	inc	h
	ld	h,(hl)
	add	a,KKU_MID_X/8
	ld	l,a
	ld	(hl),OPCRT_POINT_BITMAP
	inc	c
	djnz	OC_VertLoop
	ret
	; open lines like curtain horizontally
OC_HorzOpen:
 	call	DRAW_KKU_STARTUP

OC_HorzPhase:
	ld	a,0					; --- left mask ---
	inc	a
	cp	86
	jp	z,CALC_KKU_TEXT_PHASE
	ld	(OC_HorzPhase+1),a
	ld	c,a
	ld	a,KKU_MID_X
	sub	c
	ld	(OC_LeftEdgeXPos+1),a	; X position of left mask's edge
	ld	c,a
	and	$07					; A=X bit position
	ld	e,a
	ld	d,0
	ld	hl,OC_MaskLeftOpen
	add	hl,de
	ld	a,(hl)
	ld	de,OC_MaskEdge-OC_MaskLeftOpen
	add	hl,de
	ld	e,(hl)				; E=OR byte for drawing a vertical line
	ld	d,a					; D=AND mask for erasing left of KKU text
	ld	a,c
	and	$F8
	rra
	rra
	rra
	ld	(OC_LeftMaskByteAdd+1),a	; X byte position
	
	ld	ix,OC_LeftMinX
	ld	l,KKU_GFX_Y_PX_POS
	ld	b,KKU_HEIGHT_PX
OC_LeftMaskLoop:
OC_LeftEdgeXPos:
	ld	a,$13				; #selfmod: left mask's edge X pos
	cp	(ix+0)
	inc	ix
	jr	c,OC_SkipLeftLine
	push	hl
	ld	h,SCRLINE_LOOKUP>>8
	ld	a,(hl)
	inc	h
	ld	h,(hl)
OC_LeftMaskByteAdd:
	add	a,$13
	ld	l,a
	ld	a,(hl)				; mask the right end of left mask
	and	d
	or	e
	ld	(hl),a

	pop	hl
OC_SkipLeftLine:
	inc	l
	djnz	OC_LeftMaskLoop

	ld	a,(OC_HorzPhase+1)		; --- right mask ---
	add	a,KKU_MID_X+1
	ld	(OC_RightEdgeXPos+1),a	; X position of right mask's edge
	ld	c,a
	and	$07					; A=X bit position
	ld	e,a
	ld	d,0
	ld	hl,OC_MaskRightOpen
	add	hl,de
	ld	a,(hl)
	ld	de,OC_MaskEdge-OC_MaskRightOpen
	add	hl,de
	ld	e,(hl)				; E=OR byte for drawing a vertical line
	ld	d,a					; D=AND mask for erasing right of KKU text
	ld	a,c
	and	$F8
	rra
	rra
	rra
	ld	(OC_RightMaskByteAdd+1),a	; X byte position
	
	ld	l,KKU_GFX_Y_PX_POS
	ld	b,KKU_HEIGHT_PX
OC_RightMaskLoop:
OC_RightEdgeXPos:
	ld	a,$13				; #selfmod: right mask's edge X pos
	cp	KKU_MID_X
	jr	c,OC_SkipRightLine
	push	hl
	ld	h,SCRLINE_LOOKUP>>8
	ld	a,(hl)
	inc	h
	ld	h,(hl)
OC_RightMaskByteAdd:
	add	a,$13
	ld	l,a
	ld	a,(hl)				; mask the left end of right mask
	and	d
	or	e
	ld	(hl),a

	pop	hl
OC_SkipRightLine:
	inc	l
	djnz	OC_RightMaskLoop

	jp CALC_KKU_TEXT_PHASE
	
OC_FadeInAttrULAPlus:
	defb	$43, $44, $45, $C5, $86
OC_FadeInAttrNormCol:
	defb $4A, $4B, $4D, $4D, $4E

OC_MaskEdge:
	defb	$80, $40, $20, $10, $08, $04, $02, $01
OC_MaskLeftOpen:
	defb	$FF, $7F, $3F, $1F, $0F, $07, $03, $01
OC_MaskRightOpen:
	defb	$80, $C0, $E0, $F0, $F8, $FC, $FE, $FF
OC_LeftMinX:
	defb	88, 88, 88, 88, 88, 89, 89, 90, 91, 92, 92, 92, 92, 92, 91, 91
	defb	92, 92, 93, 93, 93, 94, 94, 94, 94, 95, 95, 95, 96, 96, 96, 96

;-------------------------------------------------------------------------------
; Draw KKU text gfx during startup. Only the part between "curtains" is drawn.
; in:  -
; out: -
; mod: AF,BC,DE,HL,AF',HL'

DRAW_KKU_STARTUP:
	ld	a,(OC_HorzPhase+1)
	add	a,5
	and	$F8
	rra
	rra
	inc	a					; A=width to draw in bytes
	cp	SCREEN_WIDTH_BYTES-KKU_GFX_X_BYTE_POS
	jp	nc,DRAW_KKU_TEXT_PROC	; if width is at max, go to the normal proc
	ld	l,a
	ld	h,0
	ld	(DKS_WidthBytes+1),hl	; width in byte LD BC,[width]
	ex	de,hl
	ld	hl,KKU_GFX_WIDTH_BYTE
	and	a
	sbc	hl,de
	ld	(DKS_AddSrcNextLine+1),hl ; next source gfx. line addition

	rr	e
	ld	a,(KKU_MID_X/8)-KKU_GFX_X_BYTE_POS
	sub	e
	ld	(DKS_AddLeft+1),a		; left addition in bytes to normal working
	; sub	KKU_GFX_X_BYTE_POS
	ld	e,a
	ld	hl,(DKT_KKU_STARTADDR_HL+1)
	add	hl,de				; source gfx. memory addr
	
	ld	(DKS_SavedSP+1),sp
	ld	sp,SCRPOS_LOOKUP_KKU

	ld	a,KKU_HEIGHT_PX
DKS_DrawBytes:
	pop	de
	ex	af,af'
	ld	a,e
DKS_AddLeft:
	add	a,$13
	ld	e,a
	ex	af,af'
DKS_WidthBytes:
	ld	bc,$1313
	ldir
DKS_AddSrcNextLine:
	ld	de,$1313
	add	hl,de
	dec	a
	jr	nz,DKS_DrawBytes

DKS_SavedSP:
	ld	sp,$1313
	ret
